﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.HR" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public enum Zakres {
        Uzyskane, Utracone, Ważne, Wszystkie
    }
        
    public class Params : ContextBase {

        public Params(Context context): base(context) {
        }
        
        KodPracyWSzególnychWarunkachCharakterze[] kody;
        [Priority(10)]
        public KodPracyWSzególnychWarunkachCharakterze[] Kody {
            get { return kody; }
            set {
                kody = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListKody() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.KodyPracySzWaCha.WgKod.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }
        
        Zakres zakres = Zakres.Ważne;
        [Priority(20)]
        public Zakres Zakres {
            get { return zakres; }
            set {
                zakres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    [Context]
    public Params Pars {
        set {
            if (value.Kody!=null && value.Kody.Length > 0)
                kody = new Set<KodPracyWSzególnychWarunkachCharakterze>(value.Kody);
            zakres = value.Zakres;
        }
    }

    [Context(typeof(OkresContext), "Okres")]
    public FromTo Okres {
        set { okres = value; }
    }

    Set<KodPracyWSzególnychWarunkachCharakterze> kody;
    Zakres zakres;
    FromTo okres;

    RowCondition condition = RowCondition.Empty;

    protected void dc_ContextLoad(object sender, EventArgs e) {
        
        ReportHeader["UPRAWNIENIA"] = Info("Kod pracy", "Kody pracy", kody==null ?  new KodPracyWSzególnychWarunkachCharakterze[]{} : kody.ToArray());
        ReportHeader["INFO"] = CaptionAttribute.EnumToString(zakres);

        bool visible = kody == null || kody.Count != 1;
        if (!visible)
            colKod.Visible = false;
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik pracownik = (Pracownik)args.Row;
        Dictionary<KodPracyWSzególnychWarunkachCharakterze, Periods> wgkodu = new Dictionary<KodPracyWSzególnychWarunkachCharakterze, Periods>();
        foreach (PracHistoria ph in pracownik.Historia) {
            KodPracyWSzególnychWarunkachCharakterze kod = ph.PracaWSzczWarunkach2009.Kod;
            FromTo okres = ph.PracaWSzczWarunkach2009.Okres * ph.Etat.EfektywnyOkres;
            if (kod != null && okres != FromTo.Empty && (kody == null || kody.Contains(kod))) {
                    Periods ps;
                    if (!wgkodu.TryGetValue(kod, out ps))
                        wgkodu.Add(kod, Periods.New(okres));
                    else
                        wgkodu[kod] = (ps + Periods.New(okres)).ToFlat();
                }
        }

        Dictionary<FromTo, KodPracyWSzególnychWarunkachCharakterze> wgOkresu = new Dictionary<FromTo, KodPracyWSzególnychWarunkachCharakterze>();
        foreach (KodPracyWSzególnychWarunkachCharakterze k in wgkodu.Keys)
            foreach (FromTo o in wgkodu[k])
                wgOkresu.Add(o, k);

        List<FromTo> okresy = new List<FromTo>(wgOkresu.Keys);
        okresy.Sort();
                    
        bool any = false;
        foreach (FromTo o in okresy) {
            switch (zakres) {
                case Zakres.Utracone:
                    if (!okres.Contains(o.To))
                        continue;
                    break;
                case Zakres.Uzyskane:
                    if (!okres.Contains(o.From))
                        continue;
                    break;
                case Zakres.Ważne:
                    if (!okres.IsIntersected(o))
                        continue;
                    break;                    
            }
        
            any = true;
            colKod.AddLine(wgOkresu[o]);
            colOdDnia.AddLine(o.From);
            colDoDnia.AddLine(o.To);
        }

        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, lst[0]);
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = obj.ToString();
            else
                info += "</strong>, <strong>" + obj.ToString();
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }

    public static void Msg(object value) {
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Znajomość języków obcych</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Praca w szczególnych warunkach lub o szczególnym charakterze&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;SPAN STYLE='FONT-SIZE: 9pt'&gt;&lt;BR&gt;&lt;/strong&gt;Wydział: &lt;strong&gt;{0}&lt;BR&gt;&lt;/strong&gt;Pośrednio: &lt;strong&gt;{1}&lt;BR&gt;&lt;/strong&gt;Okres: &lt;strong&gt;{2}&lt;BR&gt;&lt;/strong&gt;Aktualny: &lt;strong&gt;{3}%UPRAWNIENIA%&lt;BR&gt;&lt;/strong&gt;Zakres: &lt;strong&gt;%INFO%&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;&lt;/SPAN&gt;" 
                DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" 
                DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" 
                DataMember2="KadryPracownicyViewInfo+PrParams.Okres" 
                DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" 
                onbeforerow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Nazwisko" EncodeHTML="true" Caption="Nazwisko"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Imie" EncodeHTML="true" 
                        Caption="Imie" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Kod" EncodeHTML="true" 
                        Caption="Kod" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" 
                        DataMember="Workers.Info.Historia.Etat.Wydzial.Kod" EncodeHTML="true" 
                        Caption="Wydział" Width="16" NoWrap="True"></ea:GridColumn>
				    <ea:GridColumn ID="colKod" runat="server" 
                        Caption="Praca w szczególnych warunkach lub o szczególnym charakterze~kod" NoWrap="True" 
                        Width="12" VAlign="Top" Align="Center">
                    </ea:GridColumn>
				    <ea:GridColumn ID="colOdDnia" runat="server" BgColor="" 
                        Caption="Praca w szczególnych warunkach lub o szczególnym charakterze~od dnia" 
                        CssClass="" FontColor="" FontFamily="" 
                        FontSize="" Width="12" WithBarcode="None" Format="{0:b}&amp;nbsp;" 
                        NoWrap="True" Align="Center">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colDoDnia" runat="server" BgColor="" 
                        Caption="Praca w szczególnych warunkach lub o szczególnym charakterze~do dnia" 
                        CssClass="" FontColor="" FontFamily="" 
                        FontSize="" Width="12" WithBarcode="None" Format="{0:b}&amp;nbsp;" 
                        NoWrap="True" Align="Center">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

